/*
 * Decompiled with CFR 0.152.
 */
package LegendaryCardMaker;

import LegendaryCardMaker.Icon;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;

public class CardTextDialog
extends JDialog
implements ActionListener {
    private JTextArea textArea;
    private JScrollPane scroll;
    private JToolBar optionsBar = new JToolBar();
    private JButton keywordButton = new JButton("Keyword");
    private JButton regularButton = new JButton("Regular");
    private JButton headingButton = new JButton("Heading");
    private JButton focusButton = new JButton("Focus");
    private JButton headerIconButton = new JButton("Header Icon");
    private JComboBox iconCombo;
    private ComboBoxModel iconListModel;
    private JButton addButton = new JButton("Add");
    private JToolBar buttonBar = new JToolBar();
    private JButton okButton = new JButton("OK");
    private JButton cancelButton = new JButton("Cancel");
    private String originalText;
    private String returnString;
    private Locale currentLocale = Locale.getDefault();
    private ResourceBundle labels = ResourceBundle.getBundle("LegendaryCardMaker.tools.language.LegendaryCardMakerMenu", this.currentLocale);
    private ResourceBundle CardText = ResourceBundle.getBundle("LegendaryCardMaker.tools.language.LegendaryCardMakerCardText", this.currentLocale);

    public CardTextDialog(String text) {
        this.setLanguage();
        this.setModal(true);
        this.setSize(500, 300);
        this.originalText = text;
        this.keywordButton.addActionListener(this);
        this.regularButton.addActionListener(this);
        this.focusButton.addActionListener(this);
        this.headingButton.addActionListener(this);
        this.headerIconButton.addActionListener(this);
        this.addButton.addActionListener(this);
        this.optionsBar.setFloatable(false);
        this.optionsBar.add(this.keywordButton);
        this.optionsBar.add(this.regularButton);
        this.optionsBar.add(this.focusButton);
        List<Icon> icons = Icon.values();
        Collections.sort(icons, new Icon());
        this.iconCombo = new JComboBox<Object>(icons.toArray());
        this.iconCombo.setRenderer(new IconListRenderer());
        this.optionsBar.add(this.iconCombo);
        this.optionsBar.add(this.addButton);
        this.add((Component)this.optionsBar, "First");
        this.textArea = new JTextArea();
        this.textArea.setWrapStyleWord(true);
        this.textArea.setLineWrap(true);
        if (text != null) {
            this.textArea.setText(text.replace(" <g> ", "\n"));
        }
        this.scroll = new JScrollPane();
        this.scroll.setViewportView(this.textArea);
        this.add((Component)this.scroll, "Center");
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.buttonBar.setFloatable(false);
        this.buttonBar.add(this.okButton);
        this.buttonBar.add(this.cancelButton);
        this.add((Component)this.buttonBar, "Last");
    }

    public void setLanguage() {
        this.keywordButton.setText(this.labels.getString("Keyword"));
        this.regularButton.setText(this.labels.getString("Regular"));
        this.headingButton.setText(this.labels.getString("Heading"));
        this.focusButton.setText(this.labels.getString("Focus"));
        this.headerIconButton.setText(this.labels.getString("HeaderIcon"));
        this.addButton.setText(this.labels.getString("Add"));
        this.okButton.setText(this.labels.getString("OK"));
        this.cancelButton.setText(this.labels.getString("Cancel"));
    }

    public void addHeadingButton() {
        this.optionsBar.add((Component)this.headingButton, 0);
    }

    public void addHeaderIconButton() {
        this.optionsBar.add((Component)this.headerIconButton, 0);
    }

    public String showInputDialog() {
        this.setVisible(true);
        return this.returnString;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.okButton)) {
            this.returnString = this.textArea.getText().replace("\n", " <g> ");
            this.setVisible(false);
        }
        if (e.getSource().equals(this.cancelButton)) {
            this.returnString = this.originalText;
            this.setVisible(false);
        }
        if (e.getSource().equals(this.keywordButton)) {
            this.textArea.insert("<k>", this.textArea.getCaretPosition());
        }
        if (e.getSource().equals(this.regularButton)) {
            this.textArea.insert("<r>", this.textArea.getCaretPosition());
        }
        if (e.getSource().equals(this.focusButton)) {
            this.textArea.insert("\u00e2\u0178\u00b6", this.textArea.getCaretPosition());
        }
        if (e.getSource().equals(this.headingButton)) {
            this.textArea.insert("<h></h>", this.textArea.getCaretPosition());
        }
        if (e.getSource().equals(this.headerIconButton)) {
            this.textArea.insert("<hi icon= value= />", this.textArea.getCaretPosition());
        }
        if (e.getSource().equals(this.addButton)) {
            this.textArea.insert("<" + ((Icon)this.iconCombo.getSelectedItem()).getEnumName() + ">", this.textArea.getCaretPosition());
        }
    }

    public BufferedImage getCardIcon(Icon icon, int maxWidth, int maxHeight) {
        if (icon == null || icon.getImagePath() == null) {
            int type = 2;
            BufferedImage image = new BufferedImage(maxWidth, maxHeight, type);
            return image;
        }
        ImageIcon ii = new ImageIcon(icon.getImagePath());
        double r = 1.0;
        double rX = (double)maxWidth / (double)ii.getIconWidth();
        double rY = (double)maxHeight / (double)ii.getIconHeight();
        r = rY < rX ? rY : rX;
        return this.resizeImage(ii, r);
    }

    public BufferedImage resizeImage(ImageIcon imageIcon, double scale) {
        int w = (int)((double)imageIcon.getIconWidth() * scale);
        int h = (int)((double)imageIcon.getIconHeight() * scale);
        int type = 2;
        BufferedImage image = new BufferedImage(w, h, type);
        Graphics g = image.getGraphics();
        g.drawImage(imageIcon.getImage(), 0, 0, w, h, 0, 0, imageIcon.getIconWidth(), imageIcon.getIconHeight(), null);
        g.dispose();
        return image;
    }

    private class IconListRenderer
    extends DefaultListCellRenderer {
        private IconListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Icon villain = (Icon)value;
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            label.setIcon(new ImageIcon(this.getImageSummary(villain)));
            label.setHorizontalTextPosition(4);
            String s = villain.getEnumName();
            label.setText(s);
            return label;
        }

        private BufferedImage getImageSummary(Icon v) {
            int maxWidth = 24;
            int maxHeight = 24;
            BufferedImage bi = new BufferedImage(maxWidth * 2, maxHeight, 2);
            Graphics g2 = bi.getGraphics();
            int offset = 0;
            BufferedImage icon = CardTextDialog.this.getCardIcon(v, maxWidth, maxHeight);
            g2.drawImage(icon, offset + (maxWidth / 2 - icon.getWidth() / 2), maxHeight / 2 - icon.getHeight() / 2, null);
            g2.dispose();
            return bi;
        }
    }
}

